// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

varying vec4 color;

varying highp vec3 pos;

void main()
{
float p = length(pos.xyz);
vec4 fc = FOG_COLOR*1.0;
float rain = (1.0-pow(FOG_CONTROL.y,1.5));

vec3 scol = mix(vec3(0.03,0.0,0.40),
 vec3(0.00,0.115,0.350), max((0.4-fc.r)*(3.0-fc.g),0.5) );

vec3 col = mix(scol, vec3(fc.r,fc.g,fc.b*0.24), clamp(p*0.2,0.15,0.5));
col = mix(col,vec3(fc.r+fc.b*0.0, fc.g*0.0+fc.r*0.34, fc.r*0.4+fc.b*0.4)+0.3*(fc.r*fc.g*fc.b), clamp(pow(p,1.5)*1.0,0.0,0.1));
col = mix(col, fc.rgb, clamp(pow(p,4.)*0.5,0.0,1.0));
col = mix(col,vec3(fc.rgb*1.8),rain);
col = mix(col,vec3(fc.r*2.0),clamp(p*1.5,1.0,1.0)*rain);
col = mix(col,vec3(fc.rgb),clamp(pow(p,4.)*1.5,1.0,1.0)*rain);

	gl_FragColor = vec4(col,fc.a);
}
